SET FOREIGN_KEY_CHECKS=0;
ALTER TABLE `agents` ADD `roomId` VARCHAR(255) NULL, ADD `token` VARCHAR(255) NULL AFTER `is_master`;
ALTER TABLE `users` ADD `roomId` VARCHAR(255) NULL, ADD `first_name` VARCHAR(255) NULL, ADD `last_name` VARCHAR(255) NULL, ADD `token` VARCHAR(255) NULL, ADD `is_blocked` tinyint(4) DEFAULT 0 NULL   AFTER `name`;


DROP TABLE IF EXISTS `feedbacks`;
CREATE TABLE IF NOT EXISTS `feedbacks` (
  `feedback_id` int(255) NOT NULL AUTO_INCREMENT,
  `rate` tinyint(4) NOT NULL DEFAULT '0',
  `text` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `session_id` varchar(255) DEFAULT NULL,
  `room_id` varchar(255) NOT NULL,
  `date_added`  datetime NULL,
  PRIMARY KEY (`feedback_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE `rooms` ADD `is_active` TINYINT NOT NULL DEFAULT '1' AFTER `agent_id`;

DROP TABLE IF EXISTS `drawings`;
CREATE TABLE IF NOT EXISTS `drawings` (
  `drawing_id` int(255) NOT NULL AUTO_INCREMENT,
  `drawing` text DEFAULT NULL,
  `room_id` varchar(255) NOT NULL,
  PRIMARY KEY (`drawing_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE `rooms`
ADD COLUMN `agenturl_broadcast`  varchar(2048) NULL AFTER `is_active`,
ADD COLUMN `visitorurl_broadcast`  varchar(2048) NULL AFTER `agenturl_broadcast`,
ADD COLUMN `shortagenturl_broadcast`  varchar(2048) NULL AFTER `visitorurl_broadcast`,
ADD COLUMN `shortvisitorurl_broadcast`  varchar(2048) NULL AFTER `shortagenturl_broadcast`;
